/*
 * Decompiled with CFR 0.152.
 */
package pse.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import pse.configuration.ConfigurationObject;
import pse.configuration.IntegerProperty;
import pse.configuration.SimpleStringProperty;
import pse.configuration.StringProperty;
import pse.configuration.TemplateProperty;
import pse.configuration.TimeProperty;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class Configuration
extends ConfigurationObject {
    protected Map<String, IntegerProperty> integerProperties = new HashMap<String, IntegerProperty>();
    protected Map<String, SimpleStringProperty> simpleStringProperties = new HashMap<String, SimpleStringProperty>();
    protected Map<String, StringProperty> stringProperties = new HashMap<String, StringProperty>();
    protected Map<String, TemplateProperty> templateProperties = new HashMap<String, TemplateProperty>();
    protected Map<String, TimeProperty> timeProperties = new HashMap<String, TimeProperty>();
    protected String namespace;

    public String getElementName() {
        return "configuration";
    }

    public boolean hasAttributes() {
        return true;
    }

    public boolean hasChildren() {
        return super.hasChildren() || this.integerProperties.size() > 0 || this.simpleStringProperties.size() > 0 || this.stringProperties.size() > 0 || this.templateProperties.size() > 0 || this.timeProperties.size() > 0;
    }

    public int getInt(String string, int n) {
        try {
            IntegerProperty integerProperty = this.getIntegerProperty(string);
            if (integerProperty != null) {
                return integerProperty.getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public String getSimpleString(String string, String string2) {
        try {
            SimpleStringProperty simpleStringProperty = this.getSimpleStringProperty(string);
            if (simpleStringProperty != null) {
                return simpleStringProperty.getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public String getString(String string, String string2) {
        try {
            StringProperty stringProperty = this.getStringProperty(string);
            if (stringProperty != null) {
                return stringProperty.getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public String getTemplate(String string, String string2) {
        try {
            TemplateProperty templateProperty = this.getTemplateProperty(string);
            if (templateProperty != null) {
                return templateProperty.getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public long getTimeInMilliseconds(String string, long l) {
        try {
            TimeProperty timeProperty = this.getTimeProperty(string);
            if (timeProperty != null) {
                return timeProperty.getValueInMilliseconds();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }

    public int getTimeInSeconds(String string, int n) {
        try {
            TimeProperty timeProperty = this.getTimeProperty(string);
            if (timeProperty != null) {
                return timeProperty.getValueInSeconds();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public IntegerProperty getIntegerProperty(String string) {
        return this.integerProperties.get(string);
    }

    public void addIntegerProperty(IntegerProperty integerProperty) {
        this.integerProperties.put(integerProperty.getName(), integerProperty);
    }

    public SimpleStringProperty getSimpleStringProperty(String string) {
        return this.simpleStringProperties.get(string);
    }

    public void addSimpleStringProperty(SimpleStringProperty simpleStringProperty) {
        this.simpleStringProperties.put(simpleStringProperty.getName(), simpleStringProperty);
    }

    public StringProperty getStringProperty(String string) {
        return this.stringProperties.get(string);
    }

    public void addStringProperty(StringProperty stringProperty) {
        this.stringProperties.put(stringProperty.getName(), stringProperty);
    }

    public TemplateProperty getTemplateProperty(String string) {
        return this.templateProperties.get(string);
    }

    public void addTemplateProperty(TemplateProperty templateProperty) {
        this.templateProperties.put(templateProperty.getName(), templateProperty);
    }

    public TimeProperty getTimeProperty(String string) {
        return this.timeProperties.get(string);
    }

    public void addTimeProperty(TimeProperty timeProperty) {
        this.timeProperties.put(timeProperty.getName(), timeProperty);
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("namespace", this.namespace);
    }

    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        for (IntegerProperty propertyObject : Utilities.sort(this.integerProperties.values())) {
            this.addChild(xmlWriter, propertyObject);
        }
        for (SimpleStringProperty simpleStringProperty : Utilities.sort(this.simpleStringProperties.values())) {
            this.addChild(xmlWriter, simpleStringProperty);
        }
        for (StringProperty stringProperty : Utilities.sort(this.stringProperties.values())) {
            this.addChild(xmlWriter, stringProperty);
        }
        for (TemplateProperty templateProperty : Utilities.sort(this.templateProperties.values())) {
            this.addChild(xmlWriter, templateProperty);
        }
        for (TimeProperty timeProperty : Utilities.sort(this.timeProperties.values())) {
            this.addChild(xmlWriter, timeProperty);
        }
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.namespace = XmlUtils.getAttribute(node, "namespace");
    }

    protected void readChildrenFromMyNode(Node node) {
        List<Node> list;
        super.readChildrenFromMyNode(node);
        List<Node> list4 = XmlUtils.getNodeChildren(node, "integer-property");
        for (Node list32 : list4) {
            this.addIntegerProperty((IntegerProperty)this.readChildFromChildNode(list32, new IntegerProperty()));
        }
        List<Node> list5 = XmlUtils.getNodeChildren(node, "simple-string-property");
        Iterator iterator = list5.iterator();
        while (iterator.hasNext()) {
            list = (Node)iterator.next();
            this.addSimpleStringProperty((SimpleStringProperty)this.readChildFromChildNode((Node)((Object)list), new SimpleStringProperty()));
        }
        List<Node> list2 = XmlUtils.getNodeChildren(node, "string-property");
        for (Node node2 : list2) {
            this.addStringProperty((StringProperty)this.readChildFromChildNode(node2, new StringProperty()));
        }
        list = XmlUtils.getNodeChildren(node, "template-property");
        for (Node node3 : list) {
            this.addTemplateProperty((TemplateProperty)this.readChildFromChildNode(node3, new TemplateProperty()));
        }
        List<Node> list3 = XmlUtils.getNodeChildren(node, "time-property");
        for (Node node4 : list3) {
            this.addTimeProperty((TimeProperty)this.readChildFromChildNode(node4, new TimeProperty()));
        }
    }
}

